import { View, Text, FlatList,StyleSheet } from 'react-native';
import React from 'react';
import { ProductsStyle } from '../../Home/FeaturedProducts/featureProductsStyle';
import { useDispatch, useSelector } from 'react-redux';
import dpr from '../../Utilities/CustomStyleAttribute/dpr';
import FeatureProductSkeleton from '../../../src/skeletons/screens/home/FeatureProductSkeleton';
import { useNavigation } from '@react-navigation/native';
import FeatureCategories from '../../Home/FeatureCategories/FeatureCategories';
import RelatedItem from '../../Home/FeaturedProducts/ProductDetails/RelatedItem/RelatedItem';
import SingleProduct from '../../../src/components/SingleProduct/SingleProduct';
import { getMoreSearchProducts } from '../../../redux/slices/searchProducts/searchProducts';
import useAuth from '../../../hooks/useAuth';
import CustomActiveIndicator from '../../../src/components/CustomLoader/CustomActiveIndicator';
import { memo } from 'react';
import useLangTranslation from '../../../hooks/useLangTranslation';

const SearchProducts = ({ searchContent }) => {
    const navigation = useNavigation();
    const { access_token } = useAuth();
    const { trans } = useLangTranslation();
    const { searchProducts, loading, nextPageUrl, loadMore } = useSelector(
        (state) => state.searchProducts
    );
    const dispatch = useDispatch();
    const handleMoreData = () => {
        let isMounted = true;
        if (isMounted && nextPageUrl && !loadMore) {
            dispatch(getMoreSearchProducts({ access_token, URL: nextPageUrl }));
        }
        return () => {
            isMounted = false;
        };
    };
    const size = {
        contHeight: dpr(130),
        contWidth: dpr(130),
        imgHeight: dpr(45),
        imgWidth: dpr(50),
    };
    const productsStyle = ProductsStyle();
    return (
        <View style={productsStyle.container}>
            {loading ? (
                <FeatureProductSkeleton />
            ) : searchProducts?.length > 0 ? (
                <FlatList
                    keyboardShouldPersistTaps={'always'}
                    data={searchProducts}
                    keyExtractor={(_, i) => 'key-A' + i}
                    listKey={(_, i) => `listKey-A${i}`}
                    renderItem={({ item }) => (
                        <SingleProduct item={item} navigation={navigation} />
                    )}
                    showsVerticalScrollIndicator={false}
                    numColumns={2}
                    columnWrapperStyle={styles.columnWrapperStyle}
                    initialNumToRender={10}
                    windowSize={10}
                    onEndReachedThreshold={1}
                    onEndReached={handleMoreData}
                />
            ) : (
                <View>
                    <Text style={styles.itemsFoundText}>
                        0 {trans('items found for')} {searchContent}
                    </Text>
                    <FeatureCategories
                        headerText={trans('Top Categories')}
                        size={size}
                    />
                    <View style={styles.mt}>
                        <RelatedItem headerText={trans('Trending Items')} />
                    </View>
                </View>
            )}
            {loadMore && <CustomActiveIndicator />}
        </View>
    );
};

export default memo(SearchProducts);

const styles = StyleSheet.create({
    itemsFoundText: {
        textAlign: 'center',
        marginVertical: dpr(50),
        fontFamily: 'DMSans_500Medium',
        fontSize: dpr(18),
        color: '#2C2C2C',
    },
    columnWrapperStyle: {
        justifyContent: 'space-between',
    },
    mt: {
        marginTop: dpr(30),
    }
});
